#!/bin/sh
# IBM Confidential OCO Source Material
# 5630-A36 (C) COPYRIGHT International Business Machines Corp. 1997, 2003
# The source code for this program is not published or otherwise divested
# of its trade secrets, irrespective of what has been deposited with the
# U.S. Copyright Office.

usage()
{
	echo "Usage:
	  install.sh [-installRoot installRoot -hostName  hostName]
or
	  install.sh
Note:  If no command line args are passed in, these environment
variables must be set prior to running the install script.
EMBEDDEDEXPRESS_INSTALLROOT, and EMBEDDEDEXPRESS_HOSTNAME"

	exit 1
}

usageBadParam()
{
	echo "ERROR: The command line parameter, $1, is invalid."
	echo "Use -usage to see the available command line options"
	exit 1
}

usageBadInstallRoot()
{
   echo "ERROR:  $installRoot is not a valid install location."
   echo "Please use a valid full path when specifying installRoot."
   exit 1
}

usageNoJava()
{
	echo "ERROR:  JDK not found.  There must be a valid JDK"
   echo "installed to run EmbeddedExpress.  Please download the version"
   echo "of EmbeddedExpress which comes with a JDK"
	exit 1
}

usageInstallExists()
{
   echo "ERROR:  The installation has been aborted because"
   echo "$1 already exists.  Please remove"
   echo "$1 or choose an alternate installation"
   echo "location.  $1 will be automatically"
   echo "created during installation"
   exit 1
}

miscErrorOS()
{
	echo "ERROR:  An error has occurred at the OS level which will"
	echo "prevent proper installation.  Please check the system"
	echo "STDERR and/or STDOUT log(s) for	echo more information"
	echo "which may help determine the possible cause of the error."
	exit $1
}

miscErrorJConfig()
{
	echo "ERROR:  An error has occurred during config file updating"
	echo "Please check the system STDERR and/or STDOUT log(s) for"
	echo "more information which may help determine the possible"
	echo "cause of the error.  Reinstallation or hand modification of"
	echo "the config files may be needed for proper product operation."
	exit $1
}

miscErrorPriv()
{
	echo "ERROR:  Due to insufficient privileges to write to"
	echo "$1, the installation has been aborted."
	exit 1
}

parseParamsEnv()
{
   if [ -z "$EMBEDDEDEXPRESS_INSTALLROOT" ] || [ -z "$EMBEDDEDEXPRESS_HOSTNAME" ]; then usage
	else
		installRoot=$EMBEDDEDEXPRESS_INSTALLROOT
		nodeName=DefaultNode
		hostName=$EMBEDDEDEXPRESS_HOSTNAME
	fi

   if [ "$installRoot" = "" ] || [ "$hostName" = "" ]; then
      usage
   fi
}

parseParams()
{
	while [ $# -ge 1 ]; do
	case $1 in
		-installroot|-installRoot)
			installRoot=$2
			shift
		;;
		-hostname|-hostName)
			hostName=$2
			shift
		;;
		-Usage|-usage|-?)
			usage
		;;
		*)
			usageBadParam $1
		;;
	esac
	shift;
   done

   if [ "$installRoot" = "" ] || [ "$hostName" = "" ]; then
      usage
   fi
}

checkInstallRoot()
{
   ir=`echo $installRoot | cut -c1`
   if [ ! "$ir" = "/" ]; then
      usageBadInstallRoot
   fi
}

createDirs()
{
   if [ ! -d $installRoot/classes ]; then
	   mkdir -p $installRoot/classes 2> /dev/null
   fi

   if [ ! -d $installRoot/installableApps ]; then
	   mkdir -p $installRoot/installableApps 2> /dev/null
   fi

   if [ ! -d $installRoot/lib/ext ]; then
	   mkdir -p $installRoot/lib/ext 2> /dev/null
   fi

   if [ ! -d $installRoot/logs ]; then
	   mkdir -p $installRoot/logs 2> /dev/null
   fi

   if [ ! -d $installRoot/temp ]; then
	   mkdir -p $installRoot/temp 2> /dev/null
   fi

}

variableSubs()
{
	"$JAVA_HOME/jre/bin/java" \
	  -classpath $installRoot/lib/bcinstall.jar \
	  com.ibm.ws.install.bc.bcPostInstallConfig $installRoot $hostName

	jrc=$?
	if [ $jrc -ne 0 ]; then
		miscErrorJConfig $jrc
	fi
}

copySource()
{
	case $OS in
		AIX|SunOS|Solaris|HP-UX)
			cp -rp $installSrc/* $installRoot 2>/dev/null
      	cprc=$?
			if [ $cprc -ne 0 ]; then
				miscErrorOS $cprc
			fi
		;;
		Linux)
			cp -dpR $installSrc/* $installRoot 2>/dev/null
			cprc=$?
			if [ $cprc -ne 0 ]; then
				miscErrorOS $cprc
			fi
		;;
	esac
}

copyWsInstance()
{
	case $OS in
		AIX|SunOS|Solaris|HP-UX)
      	if [ -d $installRoot/bin/wsinstance ]; then
				cp -rp $installRoot/config $installRoot/bin/wsinstance/configdefaults 2>/dev/null
				cprc=$?
				if [ $cprc -ne 0 ]; then
					miscErrorOS $cprc
				fi
				
				cp -rp $installRoot/etc $installRoot/bin/wsinstance/etcdefaults 2>/dev/null
				cprc=$?
				if [ $cprc -ne 0 ]; then
					miscErrorOS $cprc
				fi
				
				mkdir -p $installRoot/bin/wsinstance/propdefaults 2> /dev/null
				cp -p $installRoot/properties/* $installRoot/bin/wsinstance/propdefaults 2>/dev/null
				if [ ! -f $installRoot/bin/wsinstance/propdefaults/wsadmin.properties ]; then
					miscErrorOS 1
				fi
			fi
		;;
		Linux)
			if [ -d $installRoot/bin/wsinstance ]; then
				cp -dpR $installRoot/config $installRoot/bin/wsinstance/configdefaults 2>/dev/null
				cprc=$?
				if [ $cprc -ne 0 ]; then
					miscErrorOS $cprc
				fi
				
				cp -dpR $installRoot/etc $installRoot/bin/wsinstance/etcdefaults 2>/dev/null
				cprc=$?
				if [ $cprc -ne 0 ]; then
					miscErrorOS $cprc
				fi
				
				mkdir -p $installRoot/bin/wsinstance/propdefaults 2> /dev/null
				cp -dp $installRoot/properties/* $installRoot/bin/wsinstance/propdefaults 2>/dev/null
				if [ ! -f $installRoot/bin/wsinstance/propdefaults/wsadmin.properties ]; then
					miscErrorOS 1
				fi
			fi
		;;
	esac
}

cleanUp()
{
	if [ -f $installRoot/install.sh ]; then
		rm -f $installRoot/install.sh
	fi

        if [ -f $installRoot/COPYRIGHT.TXT ]; then
                rm -f $installRoot/COPYRIGHT.TXT
        fi
	
	if [ -f $installRoot/lib/bcinstall.jar ]; then
		 rm $installRoot/lib/bcinstall.jar
	fi
}

checkJava()
{
   if [ -d $installSrc/java ]; then
	   JAVA_HOME=$installRoot/java
   fi

   if [ "$JAVA_HOME" = "" ]; then
	   usageNoJava
   fi
}

OS=`uname`
installSrc=`dirname $0`
nodeName=DefaultNode

if [ $# -eq 0 ]; then
	parseParamsEnv
else
	parseParams $*
fi

checkInstallRoot
checkJava

if [ ! -d $installRoot ]; then
	mkdir -p $installRoot 2> /dev/null
else
   usageInstallExists $installRoot
fi

if [ ! -w $installRoot ]; then
	miscErrorPriv $installRoot
fi

copySource
createDirs
variableSubs
copyWsInstance
cleanUp
